#ifndef __VNA_H__
#define __VNA_H__

/* message id */
#define VNA_MSG_ACK               0      /* ack */
#define VNA_MSG_FA_J1939          1      /* pgn filter add */
#define VNA_MSG_FD_J1939          2      /* pgn filter delete */
#define VNA_MSG_FA_J1587          3      /* pid filter add */
#define VNA_MSG_FD_J1587          4      /* pid filter delete */
#define VNA_MSG_TX_J1939          5      /* pgn tx (fixed SA) */
#define VNA_MSG_RX_J1939          6      /* pgn rx */
#define VNA_MSG_PX_J1939          7      /* pgn tx - periodic */
#define VNA_MSG_TX_J1587          8      /* pid tx */
#define VNA_MSG_RX_J1587          9      /* pid rx */
#define VNA_MSG_PX_J1587         10      /* pid tx - periodic */
#define VNA_MSG_RTC_SET          11      /* real-time clock */
#define VNA_MSG_SLEEP            13      /* sleep low pwr mode */
#define VNA_MSG_WAKE             14      /* sleep low pwr mode */
#define VNA_MSG_CAN_SET          15      /* can bits per second */
#define VNA_MSG_UART_SET         16      /* uart bits per second */
#define VNA_MSG_CPU_RESET        17      /* cpu reset */
#define VNA_MSG_PAMODE_SET       18      /* passall mode config */
#define VNA_MSG_TX_CAN           20      /* can rx */
#define VNA_MSG_RX_CAN           21      /* can rx */
#define VNA_MSG_RX_J1708         22      /* j1708 rx */
#define VNA_MSG_STATS            23      /* stats msg - 1 sec */
#define VNA_MSG_ACONN            25      /* obd2 auto connect */
#define VNA_MSG_FA_CAN_MSK       26      /* can id/mask filter add */
#define VNA_MSG_FD_CAN_MSK       27      /* can id/mask filter delete */
#define VNA_MSG_MCONN            28      /* can manual connect */
#define VNA_MSG_MCONN_EXT        29      /* can manual connect */
#define VNA_MSG_PSTATUS          30      /* patch status */
#define VNA_MSG_BLVER            31      /* bl version */
#define VNA_MSG_J1939_NODE_LIST  32      /* j1939 nodes on network */
#define VNA_MSG_POST             33      /* power on self test */
#define VNA_MSG_VNA_ID           34      /* vna id and version */
#define VNA_MSG_RS232_ENABLE     35      /* vna id and version */
#define VNA_MSG_FA_I15765        40      /* pid filter add */
#define VNA_MSG_FD_I15765        41      /* pid filter delete */
#define VNA_MSG_TX_I15765        42      /* pid tx */
#define VNA_MSG_RX_I15765        43      /* pid rx */
#define VNA_MSG_PX_I15765        44      /* pid tx - periodic */
#define VNA_MSG_STATS_OBD        45      /* stat msg - 1 sec */
#define VNA_MSG_ODOMETER         46      /* odometer */
#define VNA_MSG_FA_EXT_J1939     50      /* pgn filter add */
#define VNA_MSG_FD_EXT_J1939     51      /* pgn filter delete */
#define VNA_MSG_ACONN_EXT        52      /* auto connect extended */
#define VNA_MSG_TX_EXT_J1939     53      /* pgn tx (user defined SA) */
#define VNA_MSG_DRIVER_ID        60      /* driver id */
#define VNA_MSG_VNAERR           61      /* vna error */
#define VNA_MSG_STATS2           62      /* stats2 msg - 1 sec */
#define VNA_MSG_FUEL             63      /* fuel econ */
#define VNA_MSG_CHIRPCON         64      /* chirp control */
#define VNA_MSG_LEDPWR           65      /* led power */
#define VNA_MSG_GPS              69      /* gps info */
#define VNA_MSG_PAD64            70      /* scratch pad */
#define VNA_MSG_MAC              71      /* mac address */
#define VNA_MSG_REC_TOTAL        80      /* total records */
#define VNA_MSG_REC_BATCH        81      /* stream X records */
#define VNA_MSG_REC_DISCARD      82      /* discard last record batch */
#define VNA_MSG_LOGIN            85      /* login message */
#define VNA_MSG_LOGOUT           86      /* logout message */

#define VNA_MSG_BL2_START       100      /* start image copy bl */
#define VNA_MSG_BL2_DATA        101      /* data for image */
#define VNA_MSG_BL2_STOP        102      /* stop image copy bl */
#define VNA_MSG_FILE_OPEN       105      /* file open command */
#define VNA_MSG_FILE_DATA       106      /* file data */
#define VNA_MSG_HMAC_SEED       110      /* seed request */
#define VNA_MSG_HMAC_RESULT     111      /* hash result */
#define VNA_MSG_HMAC_STATE      112      /* hmac state request */
#define VNA_MSG_RESULT          252      /* result */
#define VNA_MSG_NACK            253      /* nack */
#define VNA_MSG_PAGEN           254      /* next page of vmsg */
#define VNA_MSG_REQ             255      /* request vna_msg */



#if 0
VNA_MSG_ACK:
  8b-vmsg, 8b-vmsg_ack

VNA_MSG_NACK:
  8b-vmsg, 8b-vmsg_ack, 8b-error

VNA_MSG_RESULT:
  8b-vmsg, 8b-vmsg_res, nB-result

VNA_MSG_FA_J1939:
  8b-vmsg, 8b-port, 24b-pgn

VNA_MSG_FA_EXT_J1939:
  8b-vmsg, 8b-port, 24b-pgn, 32b-period

VNA_MSG_FD_J1939:
  8b-vmsg, 8b-port, 24b-pgn

VNA_MSG_ODOMETER:
  8b-vmsg, 32b-odometer

VNA_MSG_FD_EXT_J1939:
  8b-vmsg, 8b-port, 24b-pgn

VNA_MSG_FA_J1587
  8b-vmsg, 16b-pid

VNA_MSG_FD_J1587
  8b-vmsg, 16b-pid

VNA_MSG_TX_J1939:
  8b-vmsg, 8b-port, 24b-pgn, 8b-dst, 8b-src, 8b-pri, nB-data

VNA_MSG_RX_J1939:
  8b-vmsg, 8b-port, 24b-pgn, 8b-dst, 8b-src, 8b-pri, nB-data

VNA_MSG_PX_J1939:
  8b-vmsg, 8b-port, 24b-pgn, 8b-dst, 8b-src, 8b-pri, nB-data, 16b-rate(ms)

VNA_MSG_TX_J1587
  8b-vmsg, 8b-mid, 16b-pid, 8b-pri, nB-data

VNA_MSG_RX_J1587
  8b-vmsg, 8b-mid, 16b-pid, nB-data

VNA_MSG_TX_J1587
  8b-vmsg, 8b-mid, 16b-pid, 8b-pri, nB-data, 16b-rate(ms)

VNA_MSG_CAN_SET:
  8b-vmsg, 8b-port, 8b-brp, 8b-prseg, 8b-seg1ph, 8b-seg2ph

VNA_MSG_PAMODE_SET:
  8b-vmsg, 8b-port, 8b-mode17, 8b-mode15, 8b-modeca, 8b-modej19

VNA_MSG_ACONN:
  8b-vmsg, 8b-port, 8b-can_speed, 8b-can_type

VNA_MSG_CPU_RESET:
  8b-vmsg, 24b-key

VNA_MSG_REQ:
  8b-vmsg, 8b-vmsg_req, nB-data

VNA_MSG_MCONN:
  8b-vmsg, 8b-port, 8b-can_type, 32b-can_speed

VNA_MSG_MCONN_EXT:
  8b-vmsg, 8b-port, 32b-can_type, 32b-can_speed

VNA_MSG_FA_CAN_MSK:
  8b-vmsg, 8b-port, 32b-can_id, 32b-can_id_mask

VNA_MSG_FD_CAN_MSK:
  8b-vmsg, 8b-port, 32b-can_id, 32b-can_id_mask
#endif
#endif
